**************************************************************************************************************************************************
******************* Code for 'Does monetary policy affect non-mining business investment in Australia? evidence from BLADE' *******************
***********************************************************************************************************************

**************************************************DATE: 27 Nov 2023 ******************************************************************************
**************************************************** AUTHOR: Gulnara Nolan and Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************
global inputs ""
global intermediate ""
global results ""

*** Code strcuture

*01. Initial data merge of files
*02 Variable constrcution
*03 Merge outside data









*01. Initial data merge of files


clear 
set more off 



cd "$intermediate"


adopath + ""


use "${data}\bas_q_id.dta", clear
drop if tsid>2017


merge m:1 tsid id using "${data}payg_id.dta"
keep if _m==3
drop _m

merge m:1 tsid id using "${data}\frame_id.dta"
keep if _m==3
drop _m
compress

*02 Variable constrcution

****adding birthdate

merge m:1 id using "${data}\birth_id.dta"
keep if _m==3
duplicates drop
drop if  id=="9999999999"  

drop _m

***** defining age of firms
gen age = tsid-birthyear
replace age = 0 if age == -1
drop if age < 0

g young = (age < 2)
g middle = (age > 1 & age < 10)
g old = (age > 9)
g agesq = age*age

gen younger=(age<5)
gen older=(age>=5)



*** defining industry
rename latest_anzsic06 industry
************** ANZSIC DIVISIONS ************** 

g division = "A" if industry < 600
replace division = "B" if industry > 599 & industry < 1100
replace division = "C" if industry > 1099 & industry < 2600
replace division = "D" if industry > 2599 & industry < 3000
replace division = "E" if industry > 2999 & industry < 3300
replace division = "F" if industry > 3299 & industry < 3900
replace division = "G" if industry > 3899 & industry < 4400
replace division = "H" if industry > 4399 & industry < 4600
replace division = "I" if industry > 4599 & industry < 5400
replace division = "J" if industry > 5399 & industry < 6200
replace division = "K" if industry > 6199 & industry < 6500
replace division = "L" if industry > 6599 & industry < 6800
replace division = "M" if industry > 6799 & industry < 7100
replace division = "N" if industry > 7199 & industry < 7400
replace division = "O" if industry > 7499 & industry < 8000
replace division = "P" if industry > 7999 & industry < 8300
replace division = "Q" if industry > 8399 & industry < 8800
replace division = "R" if industry > 8899 & industry < 9300
replace division = "S" if industry > 9399 & industry < 9999

*DROP PUBLIC AND FINANCE
drop if division == "O"
drop if division == "K"
*No industry
drop if division == ""


save bas_for_regs.dta, replace


encode division, gen(ind)

*** removing agriculture and mining
drop if division=="A" | division=="B" 

gen period=4*tsid + quarter

egen firmid2 = group(id)

tsset firmid2 period



g logsales=log(turnover)
g dsales=d.logsales

*** defining firm size
gen     fsize  ="Small"   if hcnt<=19 
replace fsize = "Medium"  if hcnt>=20 & hcnt<=199 
replace fsize = "Large"   if hcnt>=200 & hcnt!=. 



encode fsize, gen(fsize_)


**** dropping public sector (admin and health)
drop if division=="P" | division=="Q" 


**** investment variable is defined as intensive and extensive margins
gen intmargin=log(capex)
gen extmargin=(capex>0)
replace extmargin = . if capex==.


**** setting up periods for each variable for local projections
forvalues h=0/16 {
   
	g intmargin_`h'= f`h'.intmargin
	g extmargin_`h'= f`h'.extmargin
}

save bas_for_regs.dta, replace

*03 Merge outside data
*** preparing moenatry policy shock measure
clear 
import excel "$(inputs}\aggregate_data.xlsx", sheet("Sheet2") firstrow 

rename Month month, replace
rename Year year, replace
tostring year month, replace


gen ID=year+month 
destring year month ID, replace

*** finincial year definition
gen tsid=.

replace tsid=2002 if ID>=20017 & ID<20027 | ID==200111 | ID==200112 | ID==200110
replace tsid=2003 if ID>=20027 & ID<20037 | ID==200211 | ID==200212 | ID==200210
replace tsid=2004 if ID>=20037 & ID<20047 | ID==200311 | ID==200312 | ID==200310
replace tsid=2005 if ID>=20047 & ID<20057 | ID==200411 | ID==200412 | ID==200410
replace tsid=2006 if ID>=20057 & ID<20067 | ID==200511 | ID==200512 | ID==200510
replace tsid=2007 if ID>=20067 & ID<20077 | ID==200611 | ID==200612 | ID==200610
replace tsid=2008 if ID>=20077 & ID<20087 | ID==200711 | ID==200712 | ID==200710
replace tsid=2009 if ID>=20087 & ID<20097 | ID==200811 | ID==200812 | ID==200810
replace tsid=2010 if ID>=20097 & ID<20107 | ID==200911 | ID==200912 | ID==200910
replace tsid=2011 if ID>=20107 & ID<20117 | ID==201011 | ID==201012 | ID==201010
replace tsid=2012 if ID>=20117 & ID<20127 | ID==201111 | ID==201112 | ID==201110
replace tsid=2013 if ID>=20127 & ID<20137 | ID==201211 | ID==201212 | ID==201210
replace tsid=2014 if ID>=20137 & ID<20147 | ID==201311 | ID==201312 | ID==201310
replace tsid=2015 if ID>=20147 & ID<20157 | ID==201411 | ID==201412 | ID==201410
replace tsid=2016 if ID>=20157 & ID<20167 | ID==201511 | ID==201512 | ID==201510
replace tsid=2017 if ID>=20167 & ID<20177 | ID==201611 | ID==201612 | ID==201610
replace tsid=2018 if ID>=20177 & ID<20187 | ID==201711 | ID==201712 | ID==201710
replace tsid=2019 if ID>=20187 & ID<20197 | ID==201811 | ID==201812 | ID==201810
replace tsid=2020 if ID>=20197 & ID<20207 | ID==201911 | ID==201912 | ID==201910
drop if tsid==.


gen qr=.

** quarters were wrong, its fy
replace qr=1 if month==7 | month==8 | month==9
replace qr=2 if month==10 | month==11 | month==12
replace qr=3 if month==1 | month==2 | month==3
replace qr=4 if month==4 | month==5 | month==6

* extra measure cr_tar change  where only have months where have beckers shocks 
g cr_targ_fine = cr_targ
replace cr_targ_fine = . if beckers_aug==.
* should be summing cr_targ changes. fine to take mean to beckers here as one obs per quarter, though sum should same 
collapse (mean)  beckers beckers_aug  BT (sum) level path tp cr_targ cr_targ_fine, by(tsid qr)
save shock_bas, replace

**** preparing maro variables such as CPI, GDP and etc
clear 
import excel "$(inputs}\aggregate_data.xlsx", sheet("Sheet1") firstrow 


tostring year month, replace



gen ID=year+month 
destring year month ID, replace

gen tsid=.

replace tsid=2002 if ID>=20017 & ID<20027 | ID==200111 | ID==200112 | ID==200110
replace tsid=2003 if ID>=20027 & ID<20037 | ID==200211 | ID==200212 | ID==200210
replace tsid=2004 if ID>=20037 & ID<20047 | ID==200311 | ID==200312 | ID==200310
replace tsid=2005 if ID>=20047 & ID<20057 | ID==200411 | ID==200412 | ID==200410
replace tsid=2006 if ID>=20057 & ID<20067 | ID==200511 | ID==200512 | ID==200510
replace tsid=2007 if ID>=20067 & ID<20077 | ID==200611 | ID==200612 | ID==200610
replace tsid=2008 if ID>=20077 & ID<20087 | ID==200711 | ID==200712 | ID==200710
replace tsid=2009 if ID>=20087 & ID<20097 | ID==200811 | ID==200812 | ID==200810
replace tsid=2010 if ID>=20097 & ID<20107 | ID==200911 | ID==200912 | ID==200910
replace tsid=2011 if ID>=20107 & ID<20117 | ID==201011 | ID==201012 | ID==201010
replace tsid=2012 if ID>=20117 & ID<20127 | ID==201111 | ID==201112 | ID==201110
replace tsid=2013 if ID>=20127 & ID<20137 | ID==201211 | ID==201212 | ID==201210
replace tsid=2014 if ID>=20137 & ID<20147 | ID==201311 | ID==201312 | ID==201310
replace tsid=2015 if ID>=20147 & ID<20157 | ID==201411 | ID==201412 | ID==201410
replace tsid=2016 if ID>=20157 & ID<20167 | ID==201511 | ID==201512 | ID==201510
replace tsid=2017 if ID>=20167 & ID<20177 | ID==201611 | ID==201612 | ID==201610
replace tsid=2018 if ID>=20177 & ID<20187 | ID==201711 | ID==201712 | ID==201710
replace tsid=2019 if ID>=20187 & ID<20197 | ID==201811 | ID==201812 | ID==201810
replace tsid=2020 if ID>=20197 & ID<20207 | ID==201911 | ID==201912 | ID==201910
drop if tsid==.

keep if state_no==1

gen qr=.

** quarters were wrong, its fy
replace qr=1 if month==7 | month==8 | month==9
replace qr=2 if month==10 | month==11 | month==12
replace qr=3 if month==1 | month==2 | month==3
replace qr=4 if month==4 | month==5 | month==6


collapse (mean) cpi ur cpi_q gdp ret_q_nom ret_q_real, by(tsid qr)

merge 1:1 qr tsid using "shock_bas.dta"

tsset qr tsid 
g dur=d.ur
drop _m

rename qr quarter
merge 1:m quarter tsid using bas_for_regs.dta
keep if _m==3
drop _m
compress
rename quarter qr
save merged_bas.dta, replace

*** preparing exchange rate data
clear all

import excel "${inputs}/aggregate_data.xls", sheet("Data") firstrow clear
keep date FXRUSDA1USD FXRTWITradeweightedIndexMay
drop if FXRUSDA1USD==.
append using "P:\folder\Innovation\data\exchange rate_2010.dta" 

*use "P:\folder\Innovation\data\exchange rate_2010.dta", clear
gen year=year(date)	

drop month 
gen month=month(date)

tostring month year, replace
gen ID=year+month

drop if ID=="."
drop if ID==".."

destring month year ID, replace

gen tsid=.

replace tsid=2002 if ID>=20017 & ID<20027 | ID==200111 | ID==200112 | ID==200110
replace tsid=2003 if ID>=20027 & ID<20037 | ID==200211 | ID==200212 | ID==200210
replace tsid=2004 if ID>=20037 & ID<20047 | ID==200311 | ID==200312 | ID==200310
replace tsid=2005 if ID>=20047 & ID<20057 | ID==200411 | ID==200412 | ID==200410
replace tsid=2006 if ID>=20057 & ID<20067 | ID==200511 | ID==200512 | ID==200510
replace tsid=2007 if ID>=20067 & ID<20077 | ID==200611 | ID==200612 | ID==200610
replace tsid=2008 if ID>=20077 & ID<20087 | ID==200711 | ID==200712 | ID==200710
replace tsid=2009 if ID>=20087 & ID<20097 | ID==200811 | ID==200812 | ID==200810
replace tsid=2010 if ID>=20097 & ID<20107 | ID==200911 | ID==200912 | ID==200910
replace tsid=2011 if ID>=20107 & ID<20117 | ID==201011 | ID==201012 | ID==201010
replace tsid=2012 if ID>=20117 & ID<20127 | ID==201111 | ID==201112 | ID==201110
replace tsid=2013 if ID>=20127 & ID<20137 | ID==201211 | ID==201212 | ID==201210
replace tsid=2014 if ID>=20137 & ID<20147 | ID==201311 | ID==201312 | ID==201310
replace tsid=2015 if ID>=20147 & ID<20157 | ID==201411 | ID==201412 | ID==201410
replace tsid=2016 if ID>=20157 & ID<20167 | ID==201511 | ID==201512 | ID==201510
replace tsid=2017 if ID>=20167 & ID<20177 | ID==201611 | ID==201612 | ID==201610
replace tsid=2018 if ID>=20177 & ID<20187 | ID==201711 | ID==201712 | ID==201710
replace tsid=2019 if ID>=20187 & ID<20197 | ID==201811 | ID==201812 | ID==201810
replace tsid=2020 if ID>=20197 & ID<20207 | ID==201911 | ID==201912 | ID==201910
drop if tsid==.

gen qr=.

** quarters were wrong, its fy
replace qr=1 if month==7 | month==8 | month==9
replace qr=2 if month==10 | month==11 | month==12
replace qr=3 if month==1 | month==2 | month==3
replace qr=4 if month==4 | month==5 | month==6

collapse (mean) FXRUSDA1USD FXRTWITradeweightedIndexMay  , by (qr tsid  )

rename FXRUSDA1USD eraudusd
rename FXRTWITradeweightedIndexMay ertwi

tsset qr tsid

gen change_eraudusd=100*(eraudusd[_n]- eraudusd[_n-1])/eraudusd[_n-1]
gen change_ertwi=100*(ertwi[_n]- ertwi[_n-1])/ertwi[_n-1]


g dertwi=d.ertwi
g der=d.eraudusd

save "er_q.dta", replace


merge 1:m tsid qr using merged_bas.dta
keep if _m==3
drop _m
compress
save bas_final3.dta, replace
